import 'package:rad/widgets_html.dart';
import 'package:photogram_admin_cp/ui/widgets/logout_button.dart';

class TopNavigation extends Navigation {
  TopNavigation({
    required String clientVersion,
  }) : super(
          className: 'navbar',
          children: [
            const Division(
              className: 'navbar-content',
              child: Button(
                id: 'toggle-sidebar-btn',
                className: 'btn btn-action',
                additionalAttributes: {
                  'onclick': 'toggleSideNav()',
                },
                child: Idiomatic(className: 'fa fa-bars'),
              ),
            ),
            Anchor(
              className: 'navbar-brand ml-10 ml-sm-20',
              children: [
                const Span(className: 'd-sm-flex', innerText: 'Photogram'),
                Span(
                  className: 'badge font-size-12 text-monospace px-5 px-sm-10 ml-10 ml-sm-20',
                  innerText: 'v$clientVersion',
                ),
              ],
            ),
            const Division(
              className: 'navbar-content ml-auto',
              children: [
                Button(
                  className: 'btn btn-action mr-5',
                  additionalAttributes: {
                    'onclick': 'halfmoon.toggleDarkMode()',
                  },
                  children: [
                    Idiomatic(className: 'fa fa-moon-o'),
                    Span(className: 'sr-only', innerText: 'Toggle Dark Mode'),
                  ],
                ),
                LogoutButton(),
              ],
            ),
          ],
        );
}
